/*  Sicherung das aktuellen Standes der Plantafel. Dabei wird dafür gesorgt, dass nur eine gegebene Anzahl (5) von alten
    Sicherungen erhalten bleibt. Das soll dafür sorgen, dass die Sicherungstabelle nicht zu voll wird. */
SELECT tsystem.function__drop_by_regex( 'scheduling_log__backup_to', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.scheduling_log__backup_to( ) RETURNS VOID AS $$
  DECLARE _json              jsonb;
          _tmp               record;
          rec                record;
  BEGIN

      --- abk
      --- alte backup löschen
    PERFORM scheduling.scheduling_log__old_version__delete( 'public.abk' );

      INSERT INTO scheduling.scheduling_log( sl_tablename, sl_dbrid, sl_json )
      SELECT                                'public.abk' , dbrid   ,row_to_json( abk )
        FROM abk
       WHERE ab_buch IS false
         AND ab_done IS false;

      --- ab2
      --- alte backup löschen
    PERFORM scheduling.scheduling_log__old_version__delete( 'public.ab2' );

      INSERT INTO scheduling.scheduling_log( sl_tablename, sl_dbrid, sl_json )
      SELECT                                'public.ab2' , a2.dbrid, row_to_json( a2 )
        FROM ab2 AS a2
        JOIN abk ON ab_ix = a2_ab_ix
                AND ab_buch IS false
                AND ab_done IS false;

      --- ab2_wkstplan
    --- alte backup löschen
    PERFORM scheduling.scheduling_log__old_version__delete( 'public.ab2_wkstplan' );

      INSERT INTO scheduling.scheduling_log( sl_tablename        , sl_dbrid   , sl_json )
      SELECT                                'public.ab2_wkstplan', a2_wp.dbrid, row_to_json( a2_wp )
        FROM ab2_wkstplan AS a2_wp
        JOIN ab2 ON a2_id = a2w_a2_id
        JOIN abk ON ab_ix = a2_ab_ix
                AND ab_buch IS false
                AND ab_done IS false;

      --- scheduling.resource_timeline
    --- alte backup löschen
    PERFORM scheduling.scheduling_log__old_version__delete( 'scheduling.resource_timeline' );

      INSERT INTO scheduling.scheduling_log( sl_tablename                 , sl_dbrid          , sl_json )
      SELECT                                'scheduling.resource_timeline', ti_id::varchar(32), row_to_json( rs_tl )
        FROM scheduling.resource_timeline AS rs_tl
        JOIN ab2 ON a2_id = ti_a2_id
        JOIN abk ON ab_ix = a2_ab_ix
                AND ab_buch IS false
                AND ab_done IS false
      WHERE ti_type NOT IN ( 'off', 'off.time', 'off.day' );

      INSERT INTO scheduling.scheduling_log( sl_tablename      , sl_dbrid  , sl_json )
      SELECT DISTINCT ON (a2gr_dbrid)        'public.ab2_group', a2gr_dbrid, a2gr_json
      FROM (
             SELECT a2_gr.dbrid AS a2gr_dbrid, row_to_json( a2_gr ) AS a2gr_json
             FROM ab2_group AS a2_gr
             JOIN ab2 ON a2_id = a2g_a2_id_from OR a2_id = a2g_a2_id_to
             JOIN abk ON ab_ix = a2_ab_ix
                     AND ab_buch IS false
                     AND ab_done IS false
           ) AS sub;

  END $$ LANGUAGE plpgsql;